# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .azure_key_auth import AzureKeyAuth
from .model_cost_metric import ModelCostMetric
from .model_type import ModelType


class AzureFoundryModel(UniversalBaseModel):
    """
    +label=Azure AI Foundry Model
    """

    type: typing.Literal["integration/model/azure/ai-foundry"] = pydantic.Field(
        default="integration/model/azure/ai-foundry"
    )
    """
    +value=integration/model/azure/ai-foundry
    """

    name: str = pydantic.Field()
    """
    +label=Display Name
    +usage=Name to identify this Azure AI Foundry model
    +sort=1
    +message=2 to 62 characters long alphanumeric word, may contain - or . in between, cannot start with a number
    """

    model_id: str = pydantic.Field()
    """
    +sort=2
    +label=Model Name
    +usage=This is the Model Name on Azure
    """

    model_types: typing.List[ModelType] = pydantic.Field()
    """
    +label=Model Types
    +usage=Types of models supported by this Azure AI Foundry deployment
    +sort=200
    """

    azure_endpoint: str = pydantic.Field()
    """
    +sort=300
    +label=Azure Endpoint
    +usage=Azure Foundry endpoint
    """

    auth_data: typing.Optional[AzureKeyAuth] = None
    cost: typing.Optional[ModelCostMetric] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +uiType=Hidden
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
