# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .azure_key_auth import AzureKeyAuth
from .model_cost_metric import ModelCostMetric
from .model_type import ModelType


class AzureFoundryModelV2(UniversalBaseModel):
    """
    +label=Azure Foundry Model
    +icon=azure
    """

    type: typing.Literal["integration/model/azure-foundry"] = pydantic.Field(default="integration/model/azure-foundry")
    """
    +value=integration/model/azure-foundry
    """

    name: str = pydantic.Field()
    """
    +label=Display Name
    +sort=1
    +usage=Name to identify this Azure Foundry model in the UI
    +message=2 to 62 characters long alphanumeric word, may contain - or . in between, cannot start with a number
    """

    auth_data: AzureKeyAuth
    model_types: typing.List[ModelType] = pydantic.Field()
    """
    +label=Model Types
    +sort=3
    +usage=Types of models supported by this Azure AI Foundry deployment
    +uiProps={"disableAllOption": true}
    """

    model_id: str = pydantic.Field()
    """
    +label=Azure Deployment Name
    +sort=3
    +usage=The name of the Azure Foundry deployment
    """

    azure_endpoint: str = pydantic.Field()
    """
    +label=Azure Endpoint
    +sort=4
    +usage=The Azure AI Foundry endpoint URL
    +message=Endpoint URL must not be empty
    """

    api_version: str = pydantic.Field()
    """
    +label=API Version
    +sort=5
    +usage=The API version for the Azure Foundry model
    """

    cost: typing.Optional[ModelCostMetric] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +sort=7
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +uiType=Hidden
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
