# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class AzureOAuth(UniversalBaseModel):
    """
    +label=Azure OAuth
    """

    type: typing.Literal["oauth"] = pydantic.Field(default="oauth")
    """
    +value=oauth
    """

    tenant_id: str = pydantic.Field()
    """
    +label=Azure Tenant ID
    +usage=The Azure Active Directory tenant (directory) ID.
    +sort=100
    """

    client_id: str = pydantic.Field()
    """
    +label=Azure Client ID
    +usage=The client (application) ID of an App Registration in the tenant.
    +sort=200
    """

    client_secret: str = pydantic.Field()
    """
    +label=Azure Client secret
    +sort=300
    +usage=A client secret that was generated for the App Registration.
    +uiType=Password
    """

    subscription_id: str = pydantic.Field()
    """
    +label=Azure Subscription ID
    +usage=The ID of the target subscription. The value must be an UUID.
    +sort=400
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
