# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .azure_key_auth import AzureKeyAuth
from .model_cost_metric import ModelCostMetric
from .model_type import ModelType


class AzureOpenAiModel(UniversalBaseModel):
    """
    +label=Azure OpenAI Model
    +icon=azure
    """

    name: str = pydantic.Field()
    """
    +label=Display Name
    +sort=1
    +message=2 to 62 characters long alphanumeric word, may contain - or . in between, cannot start with a number
    """

    model_id: str = pydantic.Field()
    """
    +sort=2
    +label=Model ID
    +usage=This is the name of the deployment
    """

    type: typing.Literal["integration/model/azure"] = pydantic.Field(default="integration/model/azure")
    """
    +value=integration/model/azure
    """

    auth_data: AzureKeyAuth
    azure_endpoint: str = pydantic.Field()
    """
    +sort=100
    +label=Azure Endpoint
    +usage=Azure OpenAI Service endpoint
    """

    api_version: str = pydantic.Field()
    """
    +sort=100
    """

    model_types: typing.List[ModelType] = pydantic.Field()
    """
    +usage=Specify the type of the model
    +sort=4
    """

    cost: typing.Optional[ModelCostMetric] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +uiType=Hidden
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
