# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .model_cost_metric import ModelCostMetric
from .model_type import ModelType


class AzureOpenAiModelV2(UniversalBaseModel):
    """
    +label=Azure OpenAI Model
    +icon=azure
    """

    type: typing.Literal["integration/model/azure-openai"] = pydantic.Field(default="integration/model/azure-openai")
    """
    +value=integration/model/azure-openai
    """

    name: str = pydantic.Field()
    """
    +label=Display Name
    +sort=1
    +usage=Name to identify this Azure OpenAI model in the UI
    +message=2 to 62 characters long alphanumeric word, may contain - or . in between, cannot start with a number
    """

    model_id: str = pydantic.Field()
    """
    +label=Model ID
    +sort=2
    +usage=The name of the Azure OpenAI model deployment (e.g. gpt-35-turbo, gpt-4). Used for cost tracking and management
    +message=Model ID must not be empty
    """

    api_version: str = pydantic.Field()
    """
    +label=API Version
    +sort=3
    +usage=The Azure OpenAI API version to use
    +message=API version must not be empty
    """

    model_types: typing.List[ModelType] = pydantic.Field()
    """
    +label=Model Types
    +sort=4
    +usage=Specify the type of the Azure OpenAI model
    +uiProps={"disableAllOption": true}
    """

    cost: typing.Optional[ModelCostMetric] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +sort=6
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +uiType=Hidden
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
