# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .azure_key_auth import AzureKeyAuth
from .azure_open_ai_model_v2 import AzureOpenAiModelV2
from .collaborator import Collaborator


class AzureOpenAiProviderAccount(UniversalBaseModel):
    """
    +label=Azure OpenAI Provider Account
    +icon=azure
    """

    type: typing.Literal["provider-account/azure-openai"] = pydantic.Field(default="provider-account/azure-openai")
    """
    +value=provider-account/azure-openai
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=100
    +usage=The name of the Azure OpenAI provider account
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"disableEdit":true}
    """

    azure_endpoint: str = pydantic.Field()
    """
    +label=Azure Endpoint
    +sort=300
    +usage=The Azure OpenAI Service endpoint URL
    +message=Endpoint URL must not be empty
    """

    auth_data: AzureKeyAuth
    integrations: typing.List[AzureOpenAiModelV2] = pydantic.Field()
    """
    +label=Integrations
    +sort=500
    +usage=List of integrations that are associated with the Azure OpenAI provider account
    +uiType=IntegrationsGroup
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    +label=Collaborators
    +sort=200
    +usage=List of users who have access to this provider account
    +uiType=Collaborators
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
