# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .azure_key_auth import AzureKeyAuth
from .azure_pii_category import AzurePiiCategory
from .azure_pii_guardrail_config_domain import AzurePiiGuardrailConfigDomain


class AzurePiiGuardrailConfig(UniversalBaseModel):
    """
    +label=Azure PII
    +icon=azure
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=50
    +usage=The name of the Guardrail Config.
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"disableEdit":true}
    """

    type: typing.Literal["integration/guardrail-config/azure-pii"] = pydantic.Field(
        default="integration/guardrail-config/azure-pii"
    )
    """
    +uiType=Hidden
    +value=integration/guardrail-config/azure-pii
    """

    resource_name: str = pydantic.Field()
    """
    +label=Resource Name
    +usage=The resource name where API is deployed.
    +sort=50
    """

    api_version: str = pydantic.Field(default="2024-11-01")
    """
    +label=API Version
    +usage=API version for the Content Safety API
    +sort=100
    """

    custom_host: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Custom Host
    +usage=Custom host for the PII detection API
    +sort=200
    +uiType=Hidden
    """

    domain: AzurePiiGuardrailConfigDomain = pydantic.Field()
    """
    +label=Domain
    +usage=Domain for PII detection
    +sort=400
    """

    pii_categories: typing.List[AzurePiiCategory] = pydantic.Field()
    """
    +label=PII Categories
    +usage=Categories of PII to detect.
    +sort=500
    +uiType=MultiSelectPills
    """

    model_version: str = pydantic.Field(default="latest")
    """
    +label=Model Version
    +usage=Version of the PII detection model to use
    +sort=600
    """

    language: str = pydantic.Field(default="en")
    """
    +label=Language Code
    +usage=Language code for PII detection
    +sort=700
    """

    auth_data: AzureKeyAuth

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
