# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .azure_integrations import AzureIntegrations


class AzureProviderAccount(UniversalBaseModel):
    """
    +label=Azure
    +icon=azure
    +heroDataKey=subscription_id
    """

    type: typing.Literal["provider-account/azure"] = pydantic.Field(default="provider-account/azure")
    """
    +value=provider-account/azure
    """

    name: str = pydantic.Field()
    """
    +uiProps={"disableEdit":true}
    +label=Name
    +usage=The name of the Azure provider account.
    +sort=100
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    subscription_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Azure Subscription Id
    +usage=The ID of the target subscription. The value must be an UUID.
    +sort=200
    """

    integrations: typing.List[AzureIntegrations] = pydantic.Field()
    """
    +label=Integrations
    +usage=List of integrations that are associated with the Azure provider account.
    +sort=400
    +uiType=IntegrationsGroup
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
