# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class AzureReposIntegration(UniversalBaseModel):
    """
    +label=Azure Repo
    +icon=azure
    """

    type: typing.Literal["integration/vcs/azure"] = pydantic.Field(default="integration/vcs/azure")
    """
    +value=integration/vcs/azure
    """

    name: str = pydantic.Field()
    """
    +sort=100
    """

    account_name: str = pydantic.Field()
    """
    +label=Account Name
    +sort=200
    """

    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +sort=600
    +uiType=AuthorizedSubjects
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
