# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .base_o_auth2login_jwt_source import BaseOAuth2LoginJwtSource


class BaseOAuth2Login(UniversalBaseModel):
    """
    +label=OAuth2 Client Configuration
    +usage=OAuth2 client configuration to get the JWT.
    """

    client_id: str = pydantic.Field()
    """
    +label=Client ID
    +usage=client ID for OAuth2.
    +sort=200
    """

    client_secret: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Client Secret
    +usage=Client secret or the TrueFoundry secret containing the client secret for OAuth2.
    +sort=300
    """

    authorization_url: str = pydantic.Field()
    """
    +label=Authorization URL
    +usage=URL for the authorization request
    +sort=400
    """

    token_url: str = pydantic.Field()
    """
    +label=Token URL
    +usage=The endpoint to exchange auth code for tokens.
    +sort=500
    """

    scopes: typing.List[str] = pydantic.Field()
    """
    +label=Scopes
    +usage=List of scopes to request from the OAuth2 provider.
    +sort=600
    """

    jwt_source: BaseOAuth2LoginJwtSource = pydantic.Field()
    """
    +label=JWT Source
    +usage=Source of the JWT token to be used for verification.
    +sort=700
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
