# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .build_build_source import BuildBuildSource
from .build_build_spec import BuildBuildSpec


class Build(UniversalBaseModel):
    """
    +docs=Describes how we build our code into a Docker image.
    +label=Source Code (Build and deploy source code)
    +icon=fa-code
    """

    type: typing.Literal["build"] = pydantic.Field(default="build")
    """
    +value=build
    """

    docker_registry: typing.Optional[str] = pydantic.Field(default=None)
    """
    +docs=FQN of the container registry. You can the FQN of your desired container registry (or add one)
    in the  Integrations page[Integrations](https://app.truefoundry.tech/integrations?tab=docker-registry) page
    +label=Docker Registry
    +usage=FQN of the container registry. If you can't find your registry here,
    add it through the [Integrations](/integrations?tab=docker-registry) page
    """

    build_source: BuildBuildSource = pydantic.Field()
    """
    +docs=Source code location.
    +label=Fetch source code to build and deploy
    +icon=fa-code
    +sort=1
    """

    build_spec: BuildBuildSpec = pydantic.Field()
    """
    +docs=Instructions to build a container image out of the build source
    +label=Build using DockerFile or using Buildpack
    +icon=fa-wrench
    +sort=2
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
