# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .cerebras_integrations import CerebrasIntegrations
from .cerebras_key_auth import CerebrasKeyAuth
from .collaborator import Collaborator


class CerebrasProviderAccount(UniversalBaseModel):
    """
    +label=Cerebras Provider Account
    +icon=cerebras
    """

    type: typing.Literal["provider-account/cerebras"] = pydantic.Field(default="provider-account/cerebras")
    """
    +value=provider-account/cerebras
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=100
    +usage=The name of the Cerebras provider account
    +message=2 to 62 characters long alphanumeric word, may contain - or . in between, cannot start with a number
    """

    auth_data: CerebrasKeyAuth
    integrations: typing.Optional[typing.List[CerebrasIntegrations]] = pydantic.Field(default=None)
    """
    +label=Integrations
    +sort=300
    +usage=List of integrations that are associated with the Cerebras provider account
    +uiType=IntegrationsGroup
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    +label=Collaborators
    +sort=400
    +usage=List of users who have access to this provider account
    +uiType=Collaborators
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
