# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .cluster_manifest_cluster_type import ClusterManifestClusterType
from .cluster_manifest_monitoring import ClusterManifestMonitoring
from .cluster_manifest_node_label_keys import ClusterManifestNodeLabelKeys
from .cluster_manifest_workbench_config import ClusterManifestWorkbenchConfig
from .collaborator import Collaborator
from .ingress_controller_config import IngressControllerConfig
from .nodepool import Nodepool
from .spark_config import SparkConfig


class ClusterManifest(UniversalBaseModel):
    type: typing.Literal["cluster"] = pydantic.Field(default="cluster")
    """
    +value=cluster
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +icon=fa-desktop:#black
    +sort=10
    +message=3 to 35 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    cluster_type: ClusterManifestClusterType = pydantic.Field()
    """
    +label=Cluster Type
    +icon=fa-cloud:#7EC8E3
    +sort=20
    +usage=The cluster type of this cluster
    """

    environment_names: typing.List[str] = pydantic.Field()
    """
    +label=Environments
    +icon=fa-tags:#black
    +usage=Tag the environment like dev, staging or production. You will need to [create environments](https://docs.truefoundry.com/docs/key-concepts#creating-environments) if you don't have already.
    +sort=30
    """

    base_domains: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Base Domain URLs
    +placeholder=Enter Base Domain URL eg. devtest.mydomain.com or *.mydomain.com
    +usage=One or more base URLs, which can be either a wildcard domain (resulting in app URLs like `<app-name>-<workspace-name>.<base-domain-URL>`) or a non-wildcard domain (resulting in app URLs like `<base-domain-URL>/<app-name>-<workspace-name>`)
    > Read more about routing [here](https://docs.truefoundry.com/docs/routing) and about 'A' record and domain mapping [here](https://docs.truefoundry.com/docs/setting-up-domain)
    +icon=fa-globe:#68BBE3
    +sort=40
    +message=Domain URL should be valid domain or IP address
    """

    monitoring: typing.Optional[ClusterManifestMonitoring] = pydantic.Field(default=None)
    """
    +label=Monitoring
    +icon=fa-gear:#68BBE3
    +sort=50
    """

    default_registry_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Cluster Default Registry
    +sort=60
    """

    workbench_config: typing.Optional[ClusterManifestWorkbenchConfig] = pydantic.Field(default=None)
    """
    +label=Workbench Config
    +sort=70
    """

    spark_config: typing.Optional[SparkConfig] = None
    ingress_controller_config: typing.Optional[IngressControllerConfig] = None
    cluster_integration_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Cluster Integration FQN
    +sort=75
    +uiType=IntegrationSelect
    +uiProps={"descriptionKey": "cluster_name","integrationType": "cluster"}
    """

    workflow_storage_integration_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Workflow Storage Integration
    +sort=80
    +uiType=IntegrationSelect
    +uiProps={"descriptionKey": "cluster_name","integrationType": "blob-storage"}
    """

    supported_nodepools: typing.Optional[typing.List[Nodepool]] = pydantic.Field(default=None)
    """
    +label=Nodepools
    +usage=Add nodepools that are already created in your cluster.
    When deploying, applications can choose to schedule from these nodepools.
    +sort=90
    """

    node_label_keys: typing.Optional[ClusterManifestNodeLabelKeys] = pydantic.Field(default=None)
    """
    +label=Node Label Keys
    +usage=The node label keys that this cluster supports.
    Note: You will additionally need to add `truefoundry.com/gpu_type` label for GPU-supported node pools.
    For more information, check out [this documentation](https://docs.truefoundry.com/docs/generic-control-plane#configuring-node-pools-for-truefoundry).
    +sort=100
    """

    collaborators: typing.List[Collaborator] = pydantic.Field()
    """
    +label=Collaborators
    +usage=Collaborators who can access this cluster
    +sort=110
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
