# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .custom_basic_auth import CustomBasicAuth


class CustomBlobStorage(UniversalBaseModel):
    """
    +label=Custom Blob Storage
    +icon=puzzle-piece
    """

    type: typing.Literal["integration/blob-storage/custom"] = pydantic.Field(default="integration/blob-storage/custom")
    """
    +value=integration/blob-storage/custom
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +usage=The name of the integration that will be displayed in the TrueFoundry UI.
    +sort=100
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    endpoint: str = pydantic.Field()
    """
    +label=Endpoint
    +usage=The endpoint of the storage provider.
    +sort=200
    """

    storage_root: str = pydantic.Field()
    """
    +label=Storage Root
    +usage=The root path of the storage.
    +sort=200
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Region
    +usage=The region where the storage is located.
    +sort=600
    """

    auth_data: CustomBasicAuth
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +sort=400
    +uiType=AuthorizedSubjects
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
