# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .o_auth2login_provider import OAuth2LoginProvider


class CustomJwtAuthIntegration(UniversalBaseModel):
    """
    +label=Custom JWT Auth Integration
    +icon=puzzle-piece
    """

    type: typing.Literal["integration/jwt-auth/custom"] = pydantic.Field(default="integration/jwt-auth/custom")
    """
    +value=integration/jwt-auth/custom
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +usage=The name of the integration that will be displayed in the TrueFoundry UI.
    +sort=100
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    issuer: str = pydantic.Field()
    """
    +label=Issuer
    +usage=The base URL of the authentication provider.
    +sort=200
    """

    jwks_uri: str = pydantic.Field()
    """
    +label=JWKS URI
    +usage=The JSON Web Key Set URI for JWT verification.
    +sort=300
    """

    login_provider: typing.Optional[OAuth2LoginProvider] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +sort=500
    +uiType=AuthorizedSubjects
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
