# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .custom_model_auth_data import CustomModelAuthData
from .custom_model_model_server import CustomModelModelServer
from .model_cost_metric import ModelCostMetric
from .model_type import ModelType


class CustomModel(UniversalBaseModel):
    """
    +label=Custom Model
    +icon=puzzle-piece
    """

    name: str = pydantic.Field()
    """
    +sort=1
    +message=2 to 62 characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    hosted_model_name: str
    url: str = pydantic.Field()
    """
    +message=enter valid https/http URL that should not end with trailing slash
    """

    model_server: CustomModelModelServer
    tfy_application_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    +uiType=Hidden
    """

    type: typing.Literal["integration/model/custom"] = pydantic.Field(default="integration/model/custom")
    """
    +value=integration/model/custom
    """

    model_types: typing.List[ModelType] = pydantic.Field()
    """
    +usage=Specify the type of the model
    +sort=4
    """

    auth_data: typing.Optional[CustomModelAuthData] = pydantic.Field(default=None)
    """
    +label=Auth Data
    +usage=Custom authentication data for the integration.
    +sort=300
    """

    headers: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    +label=Custom Headers
    +usage=Custom headers for the integration. Forwarded to the provider as is. For example: `{"Authorization": "APIKey <token>"}`
    +sort=500
    """

    cost: typing.Optional[ModelCostMetric] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +sort=600
    +uiType=AuthorizedSubjects
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
