# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .data_directory_manifest_source import DataDirectoryManifestSource


class DataDirectoryManifest(UniversalBaseModel):
    """
    Data Directory manifest.
    """

    type: typing.Literal["data-dir"] = "data-dir"
    name: str = pydantic.Field()
    """
    Name of the data directory
    """

    ml_repo: str = pydantic.Field()
    """
    Name of the ML Repo to create the data directory under
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description for the data directory
    """

    metadata: typing.Dict[str, typing.Optional[typing.Any]] = pydantic.Field()
    """
    Key Value metadata. Should be valid JSON. For e.g. `{"business-unit": "sales", "quality": "good", "rating": 4.5}`
    """

    source: DataDirectoryManifestSource

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
