# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class DatabricksServicePrincipalAuth(UniversalBaseModel):
    """
    +label=Databricks Service Principal Auth
    +usage=You can authenticate using Databricks service principal. To generate OAuth secret and Client ID, go to Databricks workspace -> Workspace Settings -> Identity and Access -> Service Principals -> Secrets.
    """

    type: typing.Literal["service-principal"] = pydantic.Field(default="service-principal")
    """
    +value=service-principal
    """

    oauth_secret: str = pydantic.Field()
    """
    +label=OAuth Secret
    +usage=OAuth secret of the Databricks service principal.
    +sort=200
    +uiType=Password
    """

    client_id: str = pydantic.Field()
    """
    +label=Client ID
    +usage=Client ID or Application ID of the Databricks service principal.
    +sort=100
    +uiType=Password
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
