# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class DeploymentStatusValue(str, enum.Enum):
    INITIALIZED = "INITIALIZED"
    BUILD_SUCCESS = "BUILD_SUCCESS"
    BUILD_FAILED = "BUILD_FAILED"
    DEPLOY_FAILED = "DEPLOY_FAILED"
    DEPLOY_FAILED_WITH_RETRY = "DEPLOY_FAILED_WITH_RETRY"
    DEPLOY_SUCCESS = "DEPLOY_SUCCESS"
    ROLLOUT_STARTED = "ROLLOUT_STARTED"
    SET_TRAFFIC = "SET_TRAFFIC"
    PAUSED = "PAUSED"
    FAILED = "FAILED"
    CANCELLED = "CANCELLED"
    REDEPLOY_STARTED = "REDEPLOY_STARTED"
    BUILDING = "BUILDING"

    def visit(
        self,
        initialized: typing.Callable[[], T_Result],
        build_success: typing.Callable[[], T_Result],
        build_failed: typing.Callable[[], T_Result],
        deploy_failed: typing.Callable[[], T_Result],
        deploy_failed_with_retry: typing.Callable[[], T_Result],
        deploy_success: typing.Callable[[], T_Result],
        rollout_started: typing.Callable[[], T_Result],
        set_traffic: typing.Callable[[], T_Result],
        paused: typing.Callable[[], T_Result],
        failed: typing.Callable[[], T_Result],
        cancelled: typing.Callable[[], T_Result],
        redeploy_started: typing.Callable[[], T_Result],
        building: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is DeploymentStatusValue.INITIALIZED:
            return initialized()
        if self is DeploymentStatusValue.BUILD_SUCCESS:
            return build_success()
        if self is DeploymentStatusValue.BUILD_FAILED:
            return build_failed()
        if self is DeploymentStatusValue.DEPLOY_FAILED:
            return deploy_failed()
        if self is DeploymentStatusValue.DEPLOY_FAILED_WITH_RETRY:
            return deploy_failed_with_retry()
        if self is DeploymentStatusValue.DEPLOY_SUCCESS:
            return deploy_success()
        if self is DeploymentStatusValue.ROLLOUT_STARTED:
            return rollout_started()
        if self is DeploymentStatusValue.SET_TRAFFIC:
            return set_traffic()
        if self is DeploymentStatusValue.PAUSED:
            return paused()
        if self is DeploymentStatusValue.FAILED:
            return failed()
        if self is DeploymentStatusValue.CANCELLED:
            return cancelled()
        if self is DeploymentStatusValue.REDEPLOY_STARTED:
            return redeploy_started()
        if self is DeploymentStatusValue.BUILDING:
            return building()
