# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .developer_message_content import DeveloperMessageContent


class DeveloperMessage(UniversalBaseModel):
    """
    Developer message for the chat
    """

    role: typing.Literal["developer"] = pydantic.Field(default="developer")
    """
    The role of the messages author, in this case developer.
    """

    content: DeveloperMessageContent = pydantic.Field()
    """
    The contents of the developer message.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    An optional name for the participant.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
