# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .dockerhub_basic_auth import DockerhubBasicAuth
from .dockerhub_integrations import DockerhubIntegrations


class DockerhubProviderAccount(UniversalBaseModel):
    """
    +label=Dockerhub
    +icon=docker
    """

    type: typing.Literal["provider-account/dockerhub"] = pydantic.Field(default="provider-account/dockerhub")
    """
    +value=provider-account/dockerhub
    """

    name: str = pydantic.Field()
    """
    +uiProps={"disableEdit":true}
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    account_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Account Name
    """

    auth_data: typing.Optional[DockerhubBasicAuth] = None
    integrations: typing.List[DockerhubIntegrations] = pydantic.Field()
    """
    +uiType=IntegrationsGroup
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
