# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class DynamicVolumeConfig(UniversalBaseModel):
    """
    +label=Create new volume
    """

    type: typing.Literal["dynamic"] = pydantic.Field(default="dynamic")
    """
    +label=Volume Type
    +value=dynamic
    +usage=Volume Type for the volume.
    """

    storage_class: str = pydantic.Field()
    """
    +label=Storage Class Name
    +usage=Name of the storage class to be used for the volume.
    """

    size: int = pydantic.Field()
    """
    +label=Size(Gi)
    +unit=Gi
    +usage=Size of volume in Gi
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
