# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .smtp_credentials import SmtpCredentials


class EmailNotificationChannel(UniversalBaseModel):
    """
    +label=Email Notification Channel
    +icon=envelope
    """

    type: typing.Literal["integration/notification-channel/email"] = pydantic.Field(
        default="integration/notification-channel/email"
    )
    """
    +value=integration/notification-channel/email
    """

    name: str = pydantic.Field()
    """
    +label=Display Name
    +usage=The name of the integration that will be displayed in the TrueFoundry UI.
    +sort=100
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    auth_data: SmtpCredentials
    from_email: str = pydantic.Field()
    """
    +label=From Email
    +usage=The email address from which the email will be sent.
    +sort=1000
    """

    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +sort=1200
    +uiType=AuthorizedSubjects
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
