# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .environment_color import EnvironmentColor
from .environment_manifest import EnvironmentManifest
from .environment_optimize_for import EnvironmentOptimizeFor
from .subject import Subject


class Environment(UniversalBaseModel):
    id: typing.Optional[str] = None
    name: str
    priority: float
    color: EnvironmentColor
    tenant_name: typing_extensions.Annotated[str, FieldMetadata(alias="tenantName")]
    created_by_subject: typing_extensions.Annotated[Subject, FieldMetadata(alias="createdBySubject")]
    is_production: typing_extensions.Annotated[bool, FieldMetadata(alias="isProduction")]
    optimize_for: typing_extensions.Annotated[
        typing.Optional[EnvironmentOptimizeFor], FieldMetadata(alias="optimizeFor")
    ] = None
    manifest: EnvironmentManifest
    created_by: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="createdBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
