# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ForwardAction(UniversalBaseModel):
    type: typing.Literal["forward"] = pydantic.Field(default="forward")
    """
    +value=forward
    """

    service_uri: str = pydantic.Field()
    """
    +docs=Service uri to redirect to. This is the kubernetes fully qualified domain name that the target service can be reached on
    Eg - For a service called `sample-service` in workspace `ws` this would be `sample-service.ws.svc.cluster.local
    +label=Service URI
    """

    port: int = pydantic.Field()
    """
    +docs=Port to redirect the service traffic to
    +label=Target port
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
