# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .gcp_integrations import GcpIntegrations
from .gcp_provider_account_auth_data import GcpProviderAccountAuthData


class GcpProviderAccount(UniversalBaseModel):
    """
    +label=GCP
    +icon=googleCloud
    +heroDataKey=project_id
    """

    type: typing.Literal["provider-account/gcp"] = pydantic.Field(default="provider-account/gcp")
    """
    +value=provider-account/gcp
    """

    name: str = pydantic.Field()
    """
    +uiProps={"disableEdit":true}
    +label=Name
    +usage=The name of the GCP provider account.
    +sort=100
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    project_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Project Id
    +usage=The project id of the GCP account.
    +sort=200
    """

    auth_data: typing.Optional[GcpProviderAccountAuthData] = pydantic.Field(default=None)
    """
    +label=GCP Account Auth Data
    +usage=Authentication data for the GCP account.
    +sort=400
    """

    integrations: typing.List[GcpIntegrations] = pydantic.Field()
    """
    +label=Integrations
    +usage=List of integrations that are associated with the GCP provider account.
    +sort=500
    +uiType=IntegrationsGroup
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
