# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class GithubIntegration(UniversalBaseModel):
    """
    +label=Github
    +icon=github
    """

    type: typing.Literal["integration/vcs/github"] = pydantic.Field(default="integration/vcs/github")
    """
    +value=integration/vcs/github
    """

    name: str = pydantic.Field()
    """
    +sort=100
    """

    account_name: str = pydantic.Field()
    """
    +label=Account Name
    +sort=200
    """

    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +sort=600
    +uiType=AuthorizedSubjects
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
