# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class GitlabIntegration(UniversalBaseModel):
    """
    +label=Gitlab
    +icon=gitlab
    """

    type: typing.Literal["integration/vcs/gitlab"] = pydantic.Field(default="integration/vcs/gitlab")
    """
    +value=integration/vcs/gitlab
    """

    name: str = pydantic.Field()
    """
    +sort=100
    """

    account_name: str = pydantic.Field()
    """
    +label=Account Name
    +sort=200
    """

    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +sort=600
    +uiType=AuthorizedSubjects
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
