# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .collaborator import Collaborator
from .gcp_api_key_auth import GcpApiKeyAuth
from .gemini_model_v2 import GeminiModelV2


class GoogleGeminiProviderAccount(UniversalBaseModel):
    """
    +label=Google Gemini Provider Account
    +icon=googleCloud
    """

    type: typing.Literal["provider-account/google-gemini"] = pydantic.Field(default="provider-account/google-gemini")
    """
    +value=provider-account/google-gemini
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=100
    +usage=The name of the Google Gemini provider account
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"disableEdit":true}
    """

    auth_data: GcpApiKeyAuth
    integrations: typing.List[GeminiModelV2] = pydantic.Field()
    """
    +label=Integrations
    +sort=500
    +usage=List of integrations that are associated with the Google Gemini provider account
    +uiType=IntegrationsGroup
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    +label=Collaborators
    +sort=200
    +usage=List of users who have access to this provider account
    +uiType=Collaborators
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
