# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .gcp_api_key_auth import GcpApiKeyAuth
from .model_cost_metric import ModelCostMetric
from .model_type import ModelType


class GoogleModel(UniversalBaseModel):
    """
    +label=Google Model
    +icon=googleCloud
    """

    name: str = pydantic.Field()
    """
    +label=Display Name
    +sort=1
    +message=2 to 62 characters long alphanumeric word, may contain - or . in between, cannot start with a number
    """

    model_id: str = pydantic.Field()
    """
    +sort=2
    """

    type: typing.Literal["integration/model/gcp/google"] = pydantic.Field(default="integration/model/gcp/google")
    """
    +value=integration/model/gcp/google
    """

    model_types: typing.List[ModelType] = pydantic.Field()
    """
    +usage=Specify the type of the model
    +sort=4
    """

    auth_data: typing.Optional[GcpApiKeyAuth] = None
    cost: typing.Optional[ModelCostMetric] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +uiType=Hidden
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
