# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .collaborator import Collaborator
from .gcp_key_file_auth import GcpKeyFileAuth
from .gcp_region import GcpRegion
from .vertex_model_v2 import VertexModelV2


class GoogleVertexProviderAccount(UniversalBaseModel):
    """
    +label=Google Vertex Provider Account
    +icon=googleCloud
    +heroDataKey=project_id
    """

    type: typing.Literal["provider-account/google-vertex"] = pydantic.Field(default="provider-account/google-vertex")
    """
    +value=provider-account/google-vertex
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=100
    +usage=The name of the Google Vertex provider account
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"disableEdit":true}
    """

    project_id: str = pydantic.Field()
    """
    +label=Project ID
    +sort=200
    +usage=The Google Cloud project ID where Vertex AI is enabled
    +message=Project ID must not be empty
    """

    region: GcpRegion
    auth_data: typing.Optional[GcpKeyFileAuth] = None
    integrations: typing.List[VertexModelV2] = pydantic.Field()
    """
    +label=Integrations
    +sort=500
    +usage=List of integrations that are associated with the Google Vertex provider account
    +uiType=IntegrationsGroup
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    +label=Collaborators
    +sort=600
    +usage=List of users who have access to this provider account
    +uiType=Collaborators
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
