# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .graph_chart_type import GraphChartType


class Graph(UniversalBaseModel):
    name: str = pydantic.Field()
    """
    Name
    """

    description: str = pydantic.Field()
    """
    Description
    """

    chart: str = pydantic.Field()
    """
    Chart name
    """

    chart_type: typing_extensions.Annotated[GraphChartType, FieldMetadata(alias="chartType")] = pydantic.Field()
    """
    Chart type
    """

    params: str = pydantic.Field()
    """
    Chart params
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
