# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .model_cost_metric import ModelCostMetric
from .model_type import ModelType


class GroqModel(UniversalBaseModel):
    """
    +label=Groq Model
    +icon=groq
    """

    type: typing.Literal["integration/model/groq"] = pydantic.Field(default="integration/model/groq")
    """
    +value=integration/model/groq
    """

    name: str = pydantic.Field()
    """
    +label=Display Name
    +sort=1
    +usage=Name to identify this Groq model in the UI
    +message=2 to 62 characters long alphanumeric word, may contain - or . in between, cannot start with a number
    """

    model_id: str = pydantic.Field()
    """
    +label=Model ID
    +sort=2
    +usage=The name of the Groq model to use
    +message=Model ID must not be empty
    """

    model_types: typing.List[ModelType] = pydantic.Field()
    """
    +label=Model Types
    +sort=3
    +usage=Specify the type of the Groq model
    +uiProps={"disableAllOption": true}
    """

    cost: typing.Optional[ModelCostMetric] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +sort=5
    +usage=List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    +uiType=Hidden
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
