# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .collaborator import Collaborator
from .guardrail_config_integrations import GuardrailConfigIntegrations


class GuardrailConfigGroup(UniversalBaseModel):
    """
    +label=Guardrail Configs Group
    +icon=puzzle-piece
    """

    type: typing.Literal["provider-account/guardrail-config-group"] = pydantic.Field(
        default="provider-account/guardrail-config-group"
    )
    """
    +uiType=Hidden
    +value=provider-account/guardrail-config-group
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=100
    +usage=The name of the Guardrail Config Group.
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"disableEdit":true}
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    +label=Access Control
    +sort=200
    +usage=List of users who have access to this Guardrail Config Group.
    +uiType=Collaborators
    """

    integrations: typing.List[GuardrailConfigIntegrations] = pydantic.Field()
    """
    +label=Guardrail Configs
    +usage=List of Guardrail Configs, which are part of this Guardrail Config Group.
    +sort=400
    +uiType=IntegrationsGroup
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
