# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .guardrails_rule import GuardrailsRule


class GuardrailsConfig(UniversalBaseModel):
    """
    +label=Guardrails Configuration
    """

    name: str = pydantic.Field()
    """
    +usage=Name of the guardrails configuration
    +uiProps={"descriptionInline":true}
    +sort=1
    +label=Configuration Name
    """

    type: typing.Literal["gateway-guardrails-config"] = pydantic.Field(default="gateway-guardrails-config")
    """
    +value=gateway-guardrails-config
    +sort=2
    """

    rules: typing.List[GuardrailsRule] = pydantic.Field()
    """
    +usage=List of guardrail rules
    +uiProps={"descriptionInline":true}
    +sort=3
    +label=Guardrail Rules
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
