# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .guardrails_when import GuardrailsWhen


class GuardrailsRule(UniversalBaseModel):
    """
    +label=Guardrails Rule
    """

    id: str = pydantic.Field()
    """
    +usage=Unique identifier for the rule
    +uiProps={"descriptionInline":true}
    +sort=1
    +label=Rule ID
    """

    when: GuardrailsWhen
    input_guardrails: typing.List[str] = pydantic.Field()
    """
    +usage=Guardrail selectors of the guardrails to apply to the input (format: groupName/guardrailName)
    +uiProps={"descriptionInline":true}
    +sort=3
    +label=Input Guardrails
    """

    output_guardrails: typing.List[str] = pydantic.Field()
    """
    +usage=Guardrail selectors of the guardrails to apply to the output (format: groupName/guardrailName)
    +uiProps={"descriptionInline":true}
    +sort=4
    +label=Output Guardrails
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
