# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class HelmRepo(UniversalBaseModel):
    type: typing.Literal["helm-repo"] = pydantic.Field(default="helm-repo")
    """
    +value=helm-repo
    """

    repo_url: str = pydantic.Field()
    """
    +label=Helm repository URL
    +sort=1
    +message=Needs to be a valid URL.
    """

    integration_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    +docs=FQN of the helm repo integration. You can use the FQN of your desired helm integration (or add one)
    in the  Integrations page[Integrations](https://app.truefoundry.tech/integrations) page
    +label=Helm repo integration
    +sort=2
    +usage=FQN of the helm repo integration. If you can't find your integration here,
    add it through the [Integrations](/integrations) page
    +uiType=IntegrationSelect
    +uiProps={"integrationType":"helm-repo"}
    """

    chart: str = pydantic.Field()
    """
    +label=Chart name
    +sort=3
    +usage=The helm chart name
    +uiType=InputSelect
    +uiProps={"creatable":true, "searchable":true}
    """

    version: str = pydantic.Field()
    """
    +label=Version
    +sort=4
    +usage=Helm chart version
    +uiType=InputSelect
    +uiProps={"creatable":true, "searchable":true}
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
