# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class HttpProbe(UniversalBaseModel):
    """
    +docs=Describes the Instructions for assessing container health by executing an HTTP GET request.
    To learn more you can go [here](https://docs.truefoundry.com/docs/liveness-readiness-probe)
    +label=Instructions for assessing container health by executing an HTTP GET request.
    """

    type: typing.Literal["http"] = pydantic.Field(default="http")
    """
    +sort=1
    +label=Request Type
    +value=http
    """

    path: str = pydantic.Field()
    """
    +usage=Path to the health check endpoint
    +sort=2
    """

    port: int = pydantic.Field()
    """
    +usage=Listening port for the health check endpoint
    +sort=3
    """

    host: typing.Optional[str] = pydantic.Field(default=None)
    """
    +sort=4
    +usage=Host name to connect to, defaults to the pod IP
    """

    scheme: typing.Optional[str] = pydantic.Field(default="HTTP")
    """
    +sort=5
    +usage=Scheme to use for connecting to the host
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
