# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class HuggingfaceArtifactSource(UniversalBaseModel):
    """
    +docs=Input for Artifact from Huggingface Model Hub
    +label=Huggingface Model Source
    """

    type: typing.Literal["huggingface-hub"] = pydantic.Field(default="huggingface-hub")
    """
    +value=huggingface-hub
    """

    model_id: str = pydantic.Field()
    """
    +label=Model ID
    +usage=Model ID of the artifact to be downloaded
    """

    revision: str = pydantic.Field()
    """
    +label=Revision
    +usage=Revision of the artifact to be downloaded
    """

    ignore_patterns: typing.List[str] = pydantic.Field()
    """
    +label=Ignore Patterns
    +usage=List of patterns to ignore while downloading the artifact
    """

    download_path_env_variable: str = pydantic.Field()
    """
    +label=Download Path Environment Variable
    +usage=Environment variable which will contain the download path of the artifact
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
