# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .image_command import ImageCommand


class Image(UniversalBaseModel):
    """
    +docs=Describes that we are using a pre-built image stored in a Docker Image registry
    +label=Docker Image (Deploy an existing image)
    +icon=fa-brands fa-docker:#0db7ed
    """

    type: typing.Literal["image"] = pydantic.Field(default="image")
    """
    +value=image
    """

    image_uri: str = pydantic.Field()
    """
    +label=Image URI
    +usage=The image URI. Specify the name of the image and the tag.
    If the image is in Dockerhub, you can skip registry-url (for e.g. `tensorflow/tensorflow`).
    You can use an image from a private registry using Advanced fields
    +placeholder=registry-url/account/image:version (e.g. docker.io/tensorflow/tensorflow)
    """

    docker_registry: typing.Optional[str] = pydantic.Field(default=None)
    """
    +docs=FQN of the container registry. You can the FQN of your desired container registry (or add one)
    in the  Integrations page[Integrations](https://app.truefoundry.tech/integrations?tab=docker-registry) page
    +label=Docker Registry
    +usage=FQN of the container registry. If you can't find your registry here,
    add it through the [Integrations](/integrations?tab=docker-registry) page
    """

    command: typing.Optional[ImageCommand] = pydantic.Field(default=None)
    """
    +label=Command Override
    +usage=Override the command to run when container starts.
    When deploying a Job, the command can be templatized by defining `params` and referencing them in command
    E.g. `python main.py --learning_rate {{learning_rate}}`
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
