# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .job_alert import JobAlert
from .job_image import JobImage
from .job_mounts_item import JobMountsItem
from .job_trigger import JobTrigger
from .kustomize import Kustomize
from .param import Param
from .resources import Resources


class Job(UniversalBaseModel):
    """
    +docs=Describes the configuration for the job
    """

    type: typing.Literal["job"] = pydantic.Field(default="job")
    """
    +value=job
    """

    name: str = pydantic.Field()
    """
    +usage=Name of the job
    +sort=1
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    image: JobImage = pydantic.Field()
    """
    +docs=Specify whether you want to deploy a Docker image or build and deploy from source code
    +label=Deploy a Docker image or build and deploy from source code
    +icon=fa-solid fa-cloud-arrow-up:#21B6A8
    +sort=200
    """

    trigger: JobTrigger = pydantic.Field()
    """
    +docs=Specify the trigger
    +sort=300
    """

    trigger_on_deploy: typing.Optional[bool] = pydantic.Field(default=None)
    """
    +docs=Trigger on deploy
    +sort=350
    +usage=Trigger the job after deploy immediately
    """

    params: typing.Optional[typing.List[Param]] = pydantic.Field(default=None)
    """
    +label=Params for input
    +uiType=StructsTable
    +usage=Configure params and pass it to create different job runs
    +sort=400
    """

    env: typing.Optional[typing.Dict[str, typing.Optional[str]]] = pydantic.Field(default=None)
    """
    +label=Environment Variables
    +usage=Configure environment variables to be injected in the service either as plain text or secrets. [Docs](https://docs.truefoundry.com/docs/env-variables)
    +icon=fa-globe
    +sort=500
    """

    resources: typing.Optional[Resources] = None
    alerts: typing.Optional[typing.List[JobAlert]] = pydantic.Field(default=None)
    """
    +label=Alerts
    +usage=Configure alerts to be sent when the job starts/fails/completes
    +icon=fa-bell
    +sort=650
    """

    retries: typing.Optional[int] = pydantic.Field(default=0)
    """
    +label=Retries
    +usage=Specify the maximum number of attempts to retry a job before it is marked as failed.
    +icon=fa-repeat
    +sort=700
    """

    timeout: typing.Optional[int] = pydantic.Field(default=None)
    """
    +label=Timeout
    +usage=Job timeout in seconds.
    +icon=fa-clock
    +sort=800
    """

    concurrency_limit: typing.Optional[int] = pydantic.Field(default=None)
    """
    +label=Concurrency Limit
    +usage=Number of runs that can run concurrently
    +icon=fa-copy
    +sort=900
    """

    service_account: typing.Optional[str] = pydantic.Field(default=None)
    """
    +sort=1000
    """

    mounts: typing.Optional[typing.List[JobMountsItem]] = pydantic.Field(default=None)
    """
    +usage=Configure data to be mounted to job pod(s) as a string, secret or volume. [Docs](https://docs.truefoundry.com/docs/mounting-volumes-job)
    """

    labels: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    +label=Labels
    """

    kustomize: typing.Optional[Kustomize] = None
    workspace_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Workspace FQN
    +docs=Fully qualified name of the workspace
    +uiType=Hidden
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
