# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .notification_target import NotificationTarget


class JobAlert(UniversalBaseModel):
    """
    +docs=Describes the configuration for the job alerts
    +label=Alert
    """

    notification_channel: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Notification Channel
    +usage=Specify the notification channel to send alerts to
    +uiType=Hidden
    +sort=660
    """

    to_emails: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    +label=To Emails
    +usage=List of recipients' email addresses if the notification channel is Email.
    +docs=Specify the emails to send alerts to
    +uiType=Hidden
    +sort=665
    """

    notification_target: typing.Optional[NotificationTarget] = None
    on_start: typing.Optional[bool] = pydantic.Field(default=False)
    """
    +label=On Start
    +usage=Send an alert when the job starts
    +sort=670
    """

    on_completion: typing.Optional[bool] = False
    on_failure: typing.Optional[bool] = pydantic.Field(default=True)
    """
    +label=On Failure
    +usage=Send an alert when the job fails
    +sort=690
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
