# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class JobRunStatus(str, enum.Enum):
    """
    Status of JobRun
    """

    CREATED = "CREATED"
    SCHEDULED = "SCHEDULED"
    RUNNING = "RUNNING"
    FINISHED = "FINISHED"
    FAILED = "FAILED"
    TERMINATION_REQUESTED = "TERMINATION_REQUESTED"
    TERMINATING = "TERMINATING"
    TERMINATED = "TERMINATED"
    UNKNOWN = "UNKNOWN"

    def visit(
        self,
        created: typing.Callable[[], T_Result],
        scheduled: typing.Callable[[], T_Result],
        running: typing.Callable[[], T_Result],
        finished: typing.Callable[[], T_Result],
        failed: typing.Callable[[], T_Result],
        termination_requested: typing.Callable[[], T_Result],
        terminating: typing.Callable[[], T_Result],
        terminated: typing.Callable[[], T_Result],
        unknown: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is JobRunStatus.CREATED:
            return created()
        if self is JobRunStatus.SCHEDULED:
            return scheduled()
        if self is JobRunStatus.RUNNING:
            return running()
        if self is JobRunStatus.FINISHED:
            return finished()
        if self is JobRunStatus.FAILED:
            return failed()
        if self is JobRunStatus.TERMINATION_REQUESTED:
            return termination_requested()
        if self is JobRunStatus.TERMINATING:
            return terminating()
        if self is JobRunStatus.TERMINATED:
            return terminated()
        if self is JobRunStatus.UNKNOWN:
            return unknown()
