# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .kafka_sasl_auth import KafkaSaslAuth


class KafkaOutputConfig(UniversalBaseModel):
    """
    +docs=Describes the configuration for the output Kafka worker
    +label=Kafka
    """

    type: typing.Literal["kafka"] = pydantic.Field(default="kafka")
    """
    +value=kafka
    """

    bootstrap_servers: str = pydantic.Field()
    """
    +label=Bootstrap servers
    +usage='Kafka Bootstrap servers - Comma separated list of Kafka brokers "hostname:port" to connect to for bootstrap'
    +sort=1
    """

    topic_name: str = pydantic.Field()
    """
    +label=Topic Name
    +usage=Kafka topic to publish to
    +sort=2
    """

    tls: bool = pydantic.Field(default=True)
    """
    +label=TLS
    +usage=TLS configuration for SASL authentication
    """

    auth: typing.Optional[KafkaSaslAuth] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
