# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .retry_config import RetryConfig


class LatencyBasedLoadBalanceTarget(UniversalBaseModel):
    target: str = pydantic.Field()
    """
    Target model or provider FQN
    """

    retry_config: typing.Optional[RetryConfig] = None
    fallback_status_codes: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Status Codes for which the request will fallback to other targets. If the status code is not present in fallback_status_codes, it fails immediately.
    """

    fallback_candidate: typing.Optional[bool] = pydantic.Field(default=True)
    """
    Whether this target is a fallback candidate.  If set to false, this model will not be considered as a fallback option for targets of this load-balance-rule
    """

    override_params: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Optional parameters to override in the request
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
