# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .mcp_server_o_auth2jwt_source import McpServerOAuth2JwtSource


class McpServerOAuth2(UniversalBaseModel):
    """
    +label=OAuth2
    """

    type: typing.Literal["oauth2"] = pydantic.Field(default="oauth2")
    """
    +value=oauth2
    +label=OAuth2
    +sort=100
    +usage=OAuth2 authentication
    """

    client_id: str = pydantic.Field()
    """
    Required when DCR is disabled
    +label=Client ID
    +usage=client ID for OAuth2 or the TrueFoundry secret FQN containing the client ID.
    +sort=200
    +uiType=Password
    """

    client_secret: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Client Secret
    +usage=Client secret or the TrueFoundry secret FQN containing the client secret for OAuth2.
    +sort=300
    +uiType=Password
    """

    authorization_url: str = pydantic.Field()
    """
    +label=Authorization URL
    +usage=URL for the authorization request
    +sort=400
    """

    token_url: str = pydantic.Field()
    """
    +label=Token URL
    +usage=The endpoint to exchange auth code for tokens.
    +sort=500
    """

    scopes: typing.List[str] = pydantic.Field()
    """
    +label=Scopes
    +usage=List of scopes to request from the OAuth2 provider.
    +sort=600
    """

    jwt_source: McpServerOAuth2JwtSource = pydantic.Field()
    """
    +label=JWT Source
    +usage=Source of the JWT token to be used for verification.
    +sort=700
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
