# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .collaborator import Collaborator
from .mcp_server_integrations import McpServerIntegrations


class McpServerProviderAccount(UniversalBaseModel):
    """
    +label=MCP Server Group
    +icon=puzzle-piece
    """

    type: typing.Literal["provider-account/mcp-server-group"] = pydantic.Field(
        default="provider-account/mcp-server-group"
    )
    """
    +value=provider-account/mcp-server-group
    """

    name: str = pydantic.Field()
    """
    +label=Group Name
    +sort=100
    +usage=The name of the MCP Server Group.
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"disableEdit":true}
    """

    collaborators: typing.List[Collaborator] = pydantic.Field()
    """
    +label=Managers
    +sort=200
    +usage=List of teams/users who can manage this MCP Server Group. These subjects can add new MCP server integrations, can edit existing ones and can also use the MCP server.
    +uiType=Collaborators
    +uiProps={"optionTypes": ["Manager"]}
    """

    integrations: typing.List[McpServerIntegrations] = pydantic.Field()
    """
    +label=MCP Servers
    +usage=List of MCP Servers, which are part of this MCP Server Group.
    +sort=400
    +uiType=IntegrationsGroup
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
