# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .collaborator import Collaborator
from .mistral_ai_integrations import MistralAiIntegrations
from .mistral_ai_key_auth import MistralAiKeyAuth


class MistralAiProviderAccount(UniversalBaseModel):
    """
    +label=Mistral AI Provider Account
    +icon=mistral-ai
    """

    type: typing.Literal["provider-account/mistral-ai"] = pydantic.Field(default="provider-account/mistral-ai")
    """
    +value=provider-account/mistral-ai
    """

    name: str = pydantic.Field()
    """
    +label=Name
    +sort=100
    +usage=The name of the Mistral AI provider account
    +message=3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    +uiProps={"disableEdit":true}
    """

    auth_data: MistralAiKeyAuth
    integrations: typing.Optional[typing.List[MistralAiIntegrations]] = pydantic.Field(default=None)
    """
    +label=Integrations
    +sort=300
    +usage=List of integrations that are associated with the Mistral AI provider account
    +uiType=IntegrationsGroup
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    +label=Collaborators
    +sort=400
    +usage=List of users who have access to this provider account
    +uiType=Collaborators
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
