# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .ml_repo_manifest import MlRepoManifest
from .subject import Subject


class MlRepo(UniversalBaseModel):
    tenant_name: str = pydantic.Field()
    """
    Tenant Name
    """

    manifest: MlRepoManifest
    created_by_subject: Subject
    created_at: dt.datetime = pydantic.Field()
    """
    Created At
    """

    id: str = pydantic.Field()
    """
    Experiment Id
    """

    num_runs: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of runs
    """

    artifact_type_counts: typing.Optional[typing.Dict[str, int]] = None
    datasets_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of datasets
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
