# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .collaborator import Collaborator


class MlRepoManifest(UniversalBaseModel):
    """
    +label=MLRepo
    +usage=MLRepo is a repository ML training runs that log params, metrics, plots, images and versioned entities like artifacts, models, prompts, tools, agents
    """

    type: typing.Literal["ml-repo"] = "ml-repo"
    name: str = pydantic.Field()
    """
    +label=Name
    +icon=fa-desktop:#black
    +usage=Name of the ML Repo.
    +message=Alphanumeric word, may contain '-' with a maximum length of 100 characters
    +sort=1
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    +label=Description
    +icon=fa-desktop:#black
    +usage=Description for the ML Repo.
    +message=Description can be maximum 500 characters
    +sort=2
    +placeholder=MLRepo to track text-classification experiments and models
    +uiProps={"descriptionInline":true}
    """

    storage_integration_fqn: str = pydantic.Field()
    """
    +label=Storage Integration
    +icon=hard-drive
    +usage=Storage Integration to store artifacts and models. A storage integration represents a connected blob storage like AWS S3 / Azure Blob Storage / Google Cloud Storage.
    +message=Select the storage-integration where you want to save your artifacts and models
    [View Docs](https://docs.truefoundry.com/docs/integrations)
    +sort=4
    """

    collaborators: typing.List[Collaborator] = pydantic.Field()
    """
    +label=Collaborators
    +sort=5
    +usage=Users and Teams that have access to MLRepo
    +uiType=Collaborators
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
